% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble.R, R/lst.R
\name{tibble}
\alias{tibble}
\alias{tibble_}
\alias{data_frame}
\alias{data_frame_}
\alias{lst}
\alias{lst_}
\title{Build a data frame or list.}
\usage{
tibble(...)

tibble_(xs)

lst(...)

lst_(xs)
}
\arguments{
\item{...}{A set of name-value pairs. Arguments are evaluated sequentially,
so you can refer to previously created variables.  These arguments are
processed with \code{\link[rlang:quos]{rlang::quos()}} and support unquote via \code{!!} and
unquote-splice via \code{!!!}.}

\item{xs}{A list of unevaluated expressions created with \code{~},
\code{\link[=quote]{quote()}}, or (deprecated) \code{\link[lazyeval:lazy]{lazyeval::lazy()}}.}
}
\description{
\code{tibble()} is a trimmed down version of \code{\link[=data.frame]{data.frame()}} that:
\itemize{
\item Never coerces inputs (i.e. strings stay as strings!).
\item Never adds \code{row.names}.
\item Never munges column names.
\item Only recycles length 1 inputs.
\item Evaluates its arguments lazily and in order.
\item Adds \code{tbl_df} class to output.
\item Automatically adds column names.
}

\code{lst()} is similar to \code{\link[=list]{list()}}, but like \code{tibble()}, it
evaluates its arguments lazily and in order, and automatically adds names.
}
\examples{
a <- 1:5
tibble(a, b = a * 2)
tibble(a, b = a * 2, c = 1)
tibble(x = runif(10), y = x * 2)

lst(n = 5, x = runif(n))

# tibble never coerces its inputs
str(tibble(letters))
str(tibble(x = list(diag(1), diag(2))))

# or munges column names
tibble(`a + b` = 1:5)

# You can splice-unquote a list of quotes and formulas
tibble(!!! list(x = rlang::quo(1:10), y = quote(x * 2)))

# data frames can only contain 1d atomic vectors and lists
# and can not contain POSIXlt
\dontrun{
tibble(x = tibble(1, 2, 3))
tibble(y = strptime("2000/01/01", "\%x"))
}
lst(n = 5, x = runif(n))

# You can splice-unquote a list of quotes and formulas
lst(!!! list(n = rlang::quo(2 + 3), y = quote(runif(n))))

}
\seealso{
\code{\link[=as_tibble]{as_tibble()}} to turn an existing list into
a data frame.
}
