\name{kinesin}
\docType{data}
\alias{kinesin}
\alias{pdbs}
\alias{aln}
\alias{core}
\alias{xyz}
\alias{core}
\alias{pc.xray}
\alias{sse}
\title{Bio3d Example Data}
\description{
  These data sets contain the results of running various bio3d
  functions on example data.  The main purpose of including this
  data (which may be generated by the user by following the extended
  examples documented within the various bio3d functions) is to
  speed up example execution.  It should allow users to more quickly
  appreciate the capabilities of functions that would otherwise require
  raw data input and processing before execution.
}
\usage{
data(kinesin)
}
\format{
  Five objects from analysis of the \code{kinesin} sequence and structure
  data:

  \enumerate{
    \item{aln}{is a list with two components: \code{ali}, a character
      alignment matrix, and \code{id}, a character vector of ids/names.
      This is the output of running \code{\link{read.fasta}} on
      the example alignment \dQuote{kinesin\_xray.fa}. }
    \item{pdbs}{is a list of class \code{"3dalign"} containing aligned PDB
      structure data.  This is the output of running
      \code{\link{read.fasta.pdb}} with the \code{aln} object. }
    \item{core}{is a list of class \code{"core"} obtained by running the
      function \code{\link{core.find}} on the \code{pdbs} object.}
    \item{xyz}{is a numeric matrix of \dQuote{core fitted coordinates}
      obtained by running the function \code{\link{fit.xyz}} on the
      \code{pdbs} object, using the \dQuote{core atom indices}
      contained in \code{core}. }
    \item{pc.xray}{is a list object containing PCA results obtained by
      running the function \code{\link{pca.xyz}} on the \dQuote{core fitted
	coordinates} contained in the \code{xyz} object. }
    \item{sse}{secondary structure annotation of a representative
      kineisn structure, 1bg2, as obtained from the function
      \code{\link{dssp}} }
  }
}
\source{
  FASTA alignment and PDB structure data from the bio3d \dQuote{example}
  directory.  A related but more extensive dataset formed the basis of
  the work described in (Grant, 2007).
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
  Grant, B.J. et al. (2007) \emph{J. Mol. Biol.} \bold{368}, 1231--1248.
}
\keyword{datasets}
