/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "RipOffPluginList.h"

RipOffPluginList ripoff_plugin_list_new()
{
	RipOffPluginList new = g_new(struct RipOffPluginList_, 1);
	new->beginning = NULL;
	new->end = NULL;
	new->current = NULL;

	return new;
}

RipOffPlugin ripoff_plugin_list_start(RipOffPluginList list)
{
	list->current = list-> beginning;

	if(list->current != NULL) 
	{
		return list->current->plugin;
	}
	else
	{
		return NULL;
	}
}

RipOffPlugin ripoff_plugin_list_next_plugin(RipOffPluginList list)
{
	if(list->current != NULL)
	{
		if(list->current->next != NULL)
		{
			list->current = list->current->next;
			return list->current->plugin;
		}

		else
			return NULL;
	}

	return NULL;
}

void ripoff_plugin_list_add_plugin(RipOffPluginList list, RipOffPlugin plugin)
{
	RipOffPluginListNode node = g_new(struct RipOffPluginListNode_, 1);
	node->plugin = plugin;
	node->next = NULL;

	if(list->beginning == NULL)
	{
		list->beginning = node;
		list->end = list->beginning;
	}

	else
	{
		list->end->next = node;
		list->end = list->end->next;
	}
}	

gboolean ripoff_plugin_list_is_empty(RipOffPluginList list)
{
	if(list->beginning == NULL)
		return TRUE;
	else
		return FALSE;
}
