// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -triple=x86_64 -std=c2y %s -emit-llvm -o - | FileCheck %s

/* WG14 N3254: Yes
 * Accessing byte arrays
 *
 * NB: this basically boils down to how LLVM handles TBAA, so the best we can
 * do for a Clang test is to test that the LLVM IR we pass is reasonable and we
 * presume that LLVM has the test coverage to ensure that this behavior isn't
 * regressed.
 */

struct S {
  int x;
  char c;
  float f;
};

#define DECL_BUFFER(Ty, Name) alignas(Ty) unsigned char Name[sizeof(Ty)]

// CHECK-LABEL: define dso_local i32 @foo(
// CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[BUFFER:%.*]] = alloca [12 x i8], align 4
// CHECK-NEXT:    [[S_PTR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[BUFFER]], i8 0, i64 12, i1 false)
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY]], ptr [[S_PTR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_PTR]], align 8
// CHECK-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[TMP0]], i32 0, i32 0
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[X]], align 4
// CHECK-NEXT:    ret i32 [[TMP1]]
//
int foo() {
  DECL_BUFFER(struct S, buffer) = {};
  struct S *s_ptr = (struct S *)buffer;
  return s_ptr->x;
}

// CHECK-LABEL: define dso_local signext i8 @bar(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[BUFFER:%.*]] = alloca [12 x i8], align 4
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER]], i64 0, i64 0
// CHECK-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[ARRAYDECAY]], i32 0, i32 1
// CHECK-NEXT:    store i8 97, ptr [[C]], align 4
// CHECK-NEXT:    [[ARRAYDECAY1:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER]], i64 0, i64 0
// CHECK-NEXT:    [[C2:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDECAY1]], i32 0, i32 1
// CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[C2]], align 4
// CHECK-NEXT:    ret i8 [[TMP0]]
//
char bar() {
  DECL_BUFFER(struct S, buffer);
  ((struct S *)buffer)->c = 'a';
  return ((struct S *)buffer)->c;
}

// CHECK-LABEL: define dso_local float @baz(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[BUFFER:%.*]] = alloca [12 x i8], align 4
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER]], i64 0, i64 0
// CHECK-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[ARRAYDECAY]], i32 0, i32 2
// CHECK-NEXT:    store float 3.000000e+00, ptr [[F]], align 4
// CHECK-NEXT:    [[ARRAYDECAY1:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER]], i64 0, i64 0
// CHECK-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDECAY1]], i32 0, i32 2
// CHECK-NEXT:    [[TMP0:%.*]] = load float, ptr [[F2]], align 4
// CHECK-NEXT:    ret float [[TMP0]]
//
float baz() {
  DECL_BUFFER(struct S, buffer);
  ((struct S *)buffer)->f = 3.0f;
  return ((const struct S *)buffer)->f;
}

struct T {
  DECL_BUFFER(struct S, buffer);
};

// CHECK-LABEL: define dso_local signext i8 @quux(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[T:%.*]] = alloca [[STRUCT_T:%.*]], align 4
// CHECK-NEXT:    [[S_PTR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[T]], i8 0, i64 12, i1 false)
// CHECK-NEXT:    [[BUFFER:%.*]] = getelementptr inbounds [[STRUCT_T]], ptr [[T]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY]], ptr [[S_PTR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_PTR]], align 8
// CHECK-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[TMP0]], i32 0, i32 1
// CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[C]], align 4
// CHECK-NEXT:    ret i8 [[TMP1]]
//
char quux() {
  struct T t = {};
  struct S *s_ptr = (struct S *)t.buffer;
  return s_ptr->c;
}

// CHECK-LABEL: define dso_local float @quibble(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[BUFFER:%.*]] = alloca [12 x i8], align 4
// CHECK-NEXT:    [[T_PTR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[S_PTR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[BUFFER]], i8 0, i64 12, i1 false)
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY]], ptr [[T_PTR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[T_PTR]], align 8
// CHECK-NEXT:    [[BUFFER1:%.*]] = getelementptr inbounds [[STRUCT_T:%.*]], ptr [[TMP0]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAYDECAY2:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER1]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY2]], ptr [[S_PTR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_PTR]], align 8
// CHECK-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[TMP1]], i32 0, i32 2
// CHECK-NEXT:    [[TMP2:%.*]] = load float, ptr [[F]], align 4
// CHECK-NEXT:    ret float [[TMP2]]
//
float quibble() {
  DECL_BUFFER(struct T, buffer) = {};
  const struct T *t_ptr = (struct T *)buffer;
  const struct S *s_ptr = (struct S *)t_ptr->buffer;
  return s_ptr->f;
}

// CHECK-LABEL: define dso_local i32 @quorble(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[BUFFER:%.*]] = alloca [12 x i8], align 4
// CHECK-NEXT:    [[S_PTR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER]], i64 0, i64 0
// CHECK-NEXT:    [[BUFFER1:%.*]] = getelementptr inbounds [[STRUCT_T:%.*]], ptr [[ARRAYDECAY]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAYDECAY2:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER1]], i64 0, i64 0
// CHECK-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[ARRAYDECAY2]], i32 0, i32 0
// CHECK-NEXT:    store i32 12, ptr [[X]], align 4
// CHECK-NEXT:    [[ARRAYDECAY3:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER]], i64 0, i64 0
// CHECK-NEXT:    [[BUFFER4:%.*]] = getelementptr inbounds [[STRUCT_T]], ptr [[ARRAYDECAY3]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAYDECAY5:%.*]] = getelementptr inbounds [12 x i8], ptr [[BUFFER4]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY5]], ptr [[S_PTR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_PTR]], align 8
// CHECK-NEXT:    [[X6:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[TMP0]], i32 0, i32 0
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[X6]], align 4
// CHECK-NEXT:    ret i32 [[TMP1]]
//
int quorble() {
  DECL_BUFFER(struct T, buffer);
  ((struct S *)((struct T *)buffer)->buffer)->x = 12;
  const struct S *s_ptr = (struct S *)((struct T *)buffer)->buffer;
  return s_ptr->x;
}
