/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file TrayIcon.h
    \author Romain BONDUE
    \date 08/07/2006 */
#ifndef __TRAYICON_H__
#define __TRAYICON_H__

#include <string>

extern "C"{
#include <gtk/gtk.h>
}



namespace nsGUI
{
    class CTrayIcon
    {
      public :
            // Callback : void (*) (void*, ::GdkEventButton*) throw();
        CTrayIcon (const std::string&, ::GCallback, void*) throw();
        ~CTrayIcon () throw();
        void SetIcon (const std::string&) throw();
        void SetTooltip (const std::string&) throw();
        void Show () throw();
        void Hide () throw();
        bool IsVisible () const throw();


      private :
        ::GtkWidget* m_pTrayIcon;
        ::GtkImage* m_pIcon;
        ::GtkTooltips* const m_pToolTipsGroup;
        std::string m_CurrentIconFileName;
        ::GCallback const m_CallBack;
        void* const m_pCallBackData;

    }; // CTrayIcon

} // namespace nsGUI

#include "private/TrayIcon.hxx"

#endif // __TRAYICON_H__
