/* rygel-video-transcoder.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-video-transcoder.vala, do not modify */

/*
 * Copyright (C) 2011 Nokia Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/pbutils/codec-utils.h>
#include <gst/pbutils/descriptions.h>
#include <gst/pbutils/encoding-profile.h>
#include <gst/pbutils/encoding-target.h>
#include <gst/pbutils/gstdiscoverer.h>
#include <gst/pbutils/gstpluginsbaseversion.h>
#include <gst/pbutils/install-plugins.h>
#include <gst/pbutils/missing-plugins.h>
#include <gst/pbutils/pbutils-enumtypes.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
typedef struct _RygelGstTranscoderPrivate RygelGstTranscoderPrivate;

#define RYGEL_TYPE_AUDIO_TRANSCODER (rygel_audio_transcoder_get_type ())
#define RYGEL_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder))
#define RYGEL_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))
#define RYGEL_IS_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_IS_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_AUDIO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))

typedef struct _RygelAudioTranscoder RygelAudioTranscoder;
typedef struct _RygelAudioTranscoderClass RygelAudioTranscoderClass;
typedef struct _RygelAudioTranscoderPrivate RygelAudioTranscoderPrivate;

#define RYGEL_TYPE_VIDEO_TRANSCODER (rygel_video_transcoder_get_type ())
#define RYGEL_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder))
#define RYGEL_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))
#define RYGEL_IS_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_IS_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_VIDEO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))

typedef struct _RygelVideoTranscoder RygelVideoTranscoder;
typedef struct _RygelVideoTranscoderClass RygelVideoTranscoderClass;
typedef struct _RygelVideoTranscoderPrivate RygelVideoTranscoderPrivate;
#define _gst_mini_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelGstTranscoder {
	RygelTranscoder parent_instance;
	RygelGstTranscoderPrivate * priv;
};

struct _RygelGstTranscoderClass {
	RygelTranscoderClass parent_class;
	GstEncodingProfile* (*get_encoding_profile) (RygelGstTranscoder* self);
};

struct _RygelAudioTranscoder {
	RygelGstTranscoder parent_instance;
	RygelAudioTranscoderPrivate * priv;
	gint audio_bitrate;
	GstCaps* container_format;
	GstCaps* audio_codec_format;
};

struct _RygelAudioTranscoderClass {
	RygelGstTranscoderClass parent_class;
};

struct _RygelVideoTranscoder {
	RygelAudioTranscoder parent_instance;
	RygelVideoTranscoderPrivate * priv;
};

struct _RygelVideoTranscoderClass {
	RygelAudioTranscoderClass parent_class;
};

struct _RygelVideoTranscoderPrivate {
	gint video_bitrate;
	GstCaps* video_codec_format;
	GstCaps* video_restrictions;
};


static gpointer rygel_video_transcoder_parent_class = NULL;

GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_audio_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_video_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_VIDEO_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderPrivate))
enum  {
	RYGEL_VIDEO_TRANSCODER_DUMMY_PROPERTY
};
RygelVideoTranscoder* rygel_video_transcoder_new (const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions);
RygelVideoTranscoder* rygel_video_transcoder_construct (GType object_type, const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions);
RygelAudioTranscoder* rygel_audio_transcoder_new_with_class (const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* extension);
RygelAudioTranscoder* rygel_audio_transcoder_construct_with_class (GType object_type, const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* extension);
static GUPnPDIDLLiteResource* rygel_video_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static guint rygel_video_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
static GstEncodingProfile* rygel_video_transcoder_real_get_encoding_profile (RygelGstTranscoder* base);
GstEncodingProfile* rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_preset (RygelGstTranscoder* self);
static void rygel_video_transcoder_finalize (GObject* obj);


RygelVideoTranscoder* rygel_video_transcoder_construct (GType object_type, const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions) {
	RygelVideoTranscoder * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	const gchar* _tmp7_;
	GstCaps* _tmp8_ = NULL;
	const gchar* _tmp9_;
	g_return_val_if_fail (content_type != NULL, NULL);
	g_return_val_if_fail (dlna_profile != NULL, NULL);
	g_return_val_if_fail (container_caps != NULL, NULL);
	g_return_val_if_fail (audio_codec_caps != NULL, NULL);
	g_return_val_if_fail (video_codec_caps != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = content_type;
	_tmp1_ = dlna_profile;
	_tmp2_ = audio_bitrate;
	_tmp3_ = container_caps;
	_tmp4_ = audio_codec_caps;
	_tmp5_ = extension;
	self = (RygelVideoTranscoder*) rygel_audio_transcoder_construct_with_class (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = video_bitrate;
	self->priv->video_bitrate = _tmp6_;
	_tmp7_ = video_codec_caps;
	_tmp8_ = gst_caps_from_string (_tmp7_);
	_gst_mini_object_unref0 (self->priv->video_codec_format);
	self->priv->video_codec_format = _tmp8_;
	_tmp9_ = restrictions;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		GstCaps* _tmp11_ = NULL;
		_tmp10_ = restrictions;
		_tmp11_ = gst_caps_from_string (_tmp10_);
		_gst_mini_object_unref0 (self->priv->video_restrictions);
		self->priv->video_restrictions = _tmp11_;
	}
	return self;
}


RygelVideoTranscoder* rygel_video_transcoder_new (const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions) {
	return rygel_video_transcoder_construct (RYGEL_TYPE_VIDEO_TRANSCODER, content_type, dlna_profile, audio_bitrate, video_bitrate, container_caps, audio_codec_caps, video_codec_caps, extension, restrictions);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GUPnPDIDLLiteResource* rygel_video_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	RygelVideoTranscoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelTranscodeManager* _tmp2_;
	GUPnPDIDLLiteResource* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* resource;
	RygelMediaItem* _tmp4_;
	RygelVideoItem* _tmp5_;
	RygelVideoItem* video_item;
	RygelVideoItem* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	RygelVideoItem* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GError * _inner_error_ = NULL;
	self = (RygelVideoTranscoder*) base;
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	_tmp0_ = didl_item;
	_tmp1_ = item;
	_tmp2_ = manager;
	_tmp3_ = RYGEL_TRANSCODER_CLASS (rygel_video_transcoder_parent_class)->add_resource ((RygelTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	resource = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (resource == NULL) {
		result = NULL;
		_g_object_unref0 (resource);
		return result;
	}
	_tmp4_ = item;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp4_) : NULL);
	video_item = _tmp5_;
	_tmp6_ = video_item;
	_tmp7_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp6_);
	_tmp8_ = _tmp7_;
	gupnp_didl_lite_resource_set_width (resource, _tmp8_);
	_tmp9_ = video_item;
	_tmp10_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp9_);
	_tmp11_ = _tmp10_;
	gupnp_didl_lite_resource_set_height (resource, _tmp11_);
	_tmp12_ = self->priv->video_bitrate;
	_tmp13_ = ((RygelAudioTranscoder*) self)->audio_bitrate;
	gupnp_didl_lite_resource_set_bitrate (resource, ((_tmp12_ + _tmp13_) * 1000) / 8);
	result = resource;
	_g_object_unref0 (video_item);
	return result;
}


static guint rygel_video_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
	RygelVideoTranscoder * self;
	guint result = 0U;
	RygelMediaItem* _tmp0_;
	RygelMediaItem* _tmp2_;
	RygelVideoItem* _tmp3_;
	RygelVideoItem* video_item;
	guint _tmp4_;
	guint distance;
	RygelVideoItem* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	self = (RygelVideoTranscoder*) base;
	g_return_val_if_fail (item != NULL, 0U);
	_tmp0_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_VIDEO_ITEM)) {
		guint _tmp1_;
		_tmp1_ = G_MAXUINT;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = item;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp2_) : NULL);
	video_item = _tmp3_;
	_tmp4_ = 0;
	distance = _tmp4_;
	_tmp5_ = video_item;
	_tmp6_ = rygel_audio_item_get_bitrate ((RygelAudioItem*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ > 0) {
		guint _tmp8_;
		RygelVideoItem* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_ = 0;
		_tmp8_ = distance;
		_tmp9_ = video_item;
		_tmp10_ = rygel_audio_item_get_bitrate ((RygelAudioItem*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->video_bitrate;
		_tmp13_ = abs (_tmp11_ - _tmp12_);
		distance = _tmp8_ + _tmp13_;
	}
	result = distance;
	_g_object_unref0 (video_item);
	return result;
}


static GstEncodingProfile* rygel_video_transcoder_real_get_encoding_profile (RygelGstTranscoder* base) {
	RygelVideoTranscoder * self;
	GstEncodingProfile* result = NULL;
	GstEncodingProfile* _tmp0_ = NULL;
	GstEncodingContainerProfile* _tmp1_;
	GstEncodingContainerProfile* enc_container_profile;
	GstCaps* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GstCaps* _tmp5_;
	GstEncodingVideoProfile* _tmp6_;
	GstEncodingVideoProfile* enc_video_profile;
	GstEncodingProfile* _tmp7_;
	self = (RygelVideoTranscoder*) base;
	_tmp0_ = RYGEL_GST_TRANSCODER_CLASS (rygel_video_transcoder_parent_class)->get_encoding_profile ((RygelGstTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder));
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_encoding_container_profile_get_type ()) ? ((GstEncodingContainerProfile*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	enc_container_profile = _tmp1_;
	_tmp2_ = self->priv->video_codec_format;
	_tmp3_ = rygel_gst_transcoder_get_preset ((RygelGstTranscoder*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->video_restrictions;
	_tmp6_ = gst_encoding_video_profile_new (_tmp2_, _tmp4_, _tmp5_, (guint) 1);
	enc_video_profile = _tmp6_;
	gst_encoding_profile_set_name ((GstEncodingProfile*) enc_video_profile, "video");
	_tmp7_ = _g_object_ref0 ((GstEncodingProfile*) enc_video_profile);
	gst_encoding_container_profile_add_profile (enc_container_profile, _tmp7_);
	result = (GstEncodingProfile*) enc_container_profile;
	_g_object_unref0 (enc_video_profile);
	return result;
}


static void rygel_video_transcoder_class_init (RygelVideoTranscoderClass * klass) {
	rygel_video_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelVideoTranscoderPrivate));
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_video_transcoder_real_add_resource;
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_video_transcoder_real_get_distance;
	RYGEL_GST_TRANSCODER_CLASS (klass)->get_encoding_profile = rygel_video_transcoder_real_get_encoding_profile;
	G_OBJECT_CLASS (klass)->finalize = rygel_video_transcoder_finalize;
}


static void rygel_video_transcoder_instance_init (RygelVideoTranscoder * self) {
	self->priv = RYGEL_VIDEO_TRANSCODER_GET_PRIVATE (self);
	self->priv->video_restrictions = NULL;
}


static void rygel_video_transcoder_finalize (GObject* obj) {
	RygelVideoTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder);
	_gst_mini_object_unref0 (self->priv->video_codec_format);
	_gst_mini_object_unref0 (self->priv->video_restrictions);
	G_OBJECT_CLASS (rygel_video_transcoder_parent_class)->finalize (obj);
}


/**
 * Base class for all transcoders that handle video.
 */
GType rygel_video_transcoder_get_type (void) {
	static volatile gsize rygel_video_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoTranscoder), 0, (GInstanceInitFunc) rygel_video_transcoder_instance_init, NULL };
		GType rygel_video_transcoder_type_id;
		rygel_video_transcoder_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_TRANSCODER, "RygelVideoTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_video_transcoder_type_id__volatile, rygel_video_transcoder_type_id);
	}
	return rygel_video_transcoder_type_id__volatile;
}



