#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# jp: a SàT command line tool
# Copyright (C) 2009-2018 Jérôme Poisson (goffi@goffi.org)

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.

# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import base
from sat.core.i18n import _
from sat_frontends.jp import common
from sat_frontends.jp.constants import Const as C
from functools import partial
import os.path

__commands__ = ["MergeRequest"]


class Set(base.CommandBase):

    def __init__(self, host):
        base.CommandBase.__init__(self, host, 'set', use_pubsub=True, help=_(u'publish or update a merge request'))
        self.need_loop=True

    def add_parser_options(self):
        self.parser.add_argument("-i", "--item", type=base.unicode_decoder, default=u'', help=_(u"id or URL of the request to update, or nothing for a new one"))
        self.parser.add_argument("-r", "--repository", metavar="PATH", type=base.unicode_decoder, default=u'.', help=_(u"path of the repository (DEFAULT: current directory)"))

    def mergeRequestSetCb(self, published_id):
        if published_id:
            self.disp(u"Merge request published at {pub_id}".format(pub_id=published_id))
        else:
            self.disp(u"Merge request published")
        self.host.quit(C.EXIT_OK)

    def start(self):
        common.checkURI(self.args)
        repository = os.path.expanduser(os.path.abspath(self.args.repository))
        extra = {'update': 'true'} if self.args.item else {}
        self.host.bridge.mergeRequestSet(
            self.args.service,
            self.args.node,
            repository,
            u'auto',
            {},
            u'',
            self.args.item,
            extra,
            self.profile,
            callback=self.mergeRequestSetCb,
            errback=partial(self.errback,
                            msg=_(u"can't create merge request: {}"),
                            exit_code=C.EXIT_BRIDGE_ERRBACK))


class MergeRequest(base.CommandBase):
    subcommands = (Set,)

    def __init__(self, host):
        super(MergeRequest, self).__init__(host, 'merge-request', use_profile=False, help=_('merge-request management'))
