/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls;

import com.jidesoft.swing.RangeSlider;
import info.monitorenter.util.Range;
import info.monitorenter.util.math.MathUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RangeChooserPanel
extends JPanel {
    protected RangeSlider m_rangeSlider;
    protected NumberFormat m_nf = NumberFormat.getNumberInstance(Locale.getDefault());

    public RangeChooserPanel(Range range) {
        this.m_nf.setMinimumFractionDigits(2);
        this.m_nf.setMaximumFractionDigits(2);
        int min = (int)range.getMin();
        int max = (int)range.getMax();
        if (!MathUtil.isDouble(min) || (double)min == -1.7976931348623157E308) {
            min = -100;
        }
        if (!MathUtil.isDouble(max) || (double)max == Double.MAX_VALUE) {
            max = 100;
        }
        int minBound = min - (max - min) / 2;
        int maxBound = max + (max - min) / 2;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.m_rangeSlider = new RangeSlider();
        this.m_rangeSlider.setMinimum(minBound);
        this.m_rangeSlider.setMaximum(maxBound);
        this.m_rangeSlider.setHighValue(max);
        this.m_rangeSlider.setLowValue(min);
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(new FlowLayout());
        rangePanel.add((Component)this.m_rangeSlider);
        this.add(rangePanel);
        this.add(Box.createVerticalStrut(10));
        final JTextField rangeMinView = new JTextField();
        rangeMinView.setText(this.m_nf.format(new Double(this.m_rangeSlider.getLowValue())));
        rangeMinView.setEditable(true);
        rangeMinView.setPreferredSize(new Dimension(120, 20));
        rangeMinView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JTextField textField = (JTextField)ae.getSource();
                try {
                    Number entered = RangeChooserPanel.this.m_nf.parse(textField.getText());
                    int low = entered.intValue();
                    int high = RangeChooserPanel.this.m_rangeSlider.getHighValue();
                    int minSlider = low - (high - low) / 2;
                    RangeChooserPanel.this.m_rangeSlider.setMinimum(minSlider);
                    RangeChooserPanel.this.m_rangeSlider.setLowValue(low);
                }
                catch (ParseException e) {
                    textField.setText(RangeChooserPanel.this.m_nf.format(RangeChooserPanel.this.m_rangeSlider.getMinimum()));
                    e.printStackTrace();
                }
            }
        });
        rangeMinView.setToolTipText("Enter a number and hit Return.");
        final JTextField rangeMaxView = new JTextField();
        rangeMaxView.setText(new Double(this.m_rangeSlider.getHighValue()).toString());
        rangeMaxView.setEditable(true);
        rangeMaxView.setPreferredSize(new Dimension(120, 20));
        rangeMaxView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JTextField textField = (JTextField)ae.getSource();
                try {
                    Number entered = RangeChooserPanel.this.m_nf.parse(textField.getText());
                    int high = entered.intValue();
                    int low = RangeChooserPanel.this.m_rangeSlider.getLowValue();
                    int maxSlider = (high - low) / 2;
                    RangeChooserPanel.this.m_rangeSlider.setMaximum(maxSlider);
                    RangeChooserPanel.this.m_rangeSlider.setHighValue(high);
                }
                catch (ParseException e) {
                    textField.setText(RangeChooserPanel.this.m_nf.format(RangeChooserPanel.this.m_rangeSlider.getMaximum()));
                    e.printStackTrace();
                }
            }
        });
        rangeMaxView.setToolTipText("Enter a number and hit Return.");
        this.m_rangeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RangeSlider slider = (RangeSlider)e.getSource();
                int value = slider.getLowValue();
                String text = RangeChooserPanel.this.m_nf.format(value);
                rangeMinView.setText(text);
                value = slider.getHighValue();
                text = RangeChooserPanel.this.m_nf.format(value);
                rangeMaxView.setText(text);
            }
        });
        JPanel rangeViewPanel = new JPanel();
        rangeViewPanel.setMaximumSize(new Dimension(300, 30));
        rangeViewPanel.setLayout(new BoxLayout(rangeViewPanel, 0));
        rangeViewPanel.add(Box.createHorizontalGlue());
        rangeViewPanel.add(rangeMinView);
        rangeViewPanel.add(Box.createHorizontalStrut(10));
        rangeViewPanel.add(rangeMaxView);
        rangeViewPanel.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(10));
        this.add(rangeViewPanel);
        this.add(Box.createVerticalGlue());
    }

    public Range getRange() {
        return new Range(this.m_rangeSlider.getLowValue(), this.m_rangeSlider.getHighValue());
    }
}

