// SPDX-FileCopyrightText: 2006-2025 Knut Reinert & Freie Universität Berlin
// SPDX-FileCopyrightText: 2016-2025 Knut Reinert & MPI für molekulare Genetik
// SPDX-License-Identifier: BSD-3-Clause

/*!\file
 * \brief Meta-header for the \link alignment_decorator Alignment / Decorator submodule \endlink.
 * \author Svenja Mehringer <svenja.mehringer AT fu-berlin.de>
 */

/*!\defgroup alignment_decorator Decorator
 * \brief The decorator submodule contains special SeqAn decorators.
 * \ingroup alignment
 *
 * This submodule contains SeqAn decorators that can be used in an alignment context.
 *
 * \see alignment
 * \see alignment_pairwise
 */

#pragma once

#include <seqan3/alignment/decorator/gap_decorator.hpp>
