/* ====================================================================
 * Copyright (c) 2007-2008, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGVIEWMODEL_H
#define _SC_LOGVIEWMODEL_H

// sc
#include "sublib/TargetId.h"
#include "svn/LogEntryTypes.h"
#include "svn/ClientTypes.h"
#include "svn/Revision.h"
#include "util/String.h"
class DiffViewModel;
class MergeViewModel;
class ScModel;
class Bookmark;
class LogParam;
class DiffParam;
class CatParam;
class InfoParam;
class PropSetRevParam;
namespace sc {
  class Error;
}

// qt
#include <QtCore/QObject>

// boost
#include <boost/shared_ptr.hpp>


class LogViewModel : public QObject, public TargetId
{
  typedef QObject super;
   Q_OBJECT;

public:
  LogViewModel( const sc::String& name, bool dir, Bookmark* bm, ScModel* model );
  ~LogViewModel();

  // QObject
  bool event( QEvent* e );

  DiffViewModel* createDiffViewModel();
  MergeViewModel* createMergeViewModel( bool undo );

  Bookmark* getBookmark() const;
  const sc::String& getName() const;
  bool  isDir() const;

  // commands
public slots:
  void log();
  void logResult( LogParam*, const sc::Error* );
  void propsetrev();
  void diffc();
  void diffCommitPath();
  void diffwc();
  void diffResult( DiffParam*, const sc::Error* );
  void cat();
  void catResult( CatParam*, const sc::Error* );
  void infoResult( InfoParam*, const sc::Error* );

public:
  svn::RevisionPtr getStartRevision();
  svn::RevisionPtr getStopRevision();
  bool getCopies();
  bool getChanges();
  bool getLimit();
  int getLimitVal();
  bool isVisualDiff();

  void setSelection( svn::LogEntries& entries );
  void setSelection( svn::Paths& paths );

public slots:
  void setStartRevision( svn::RevisionPtr );
  void setStopRevision( svn::RevisionPtr );
  void setCopies( bool );
  void setChanges( bool );
  void setLimit( bool );
  void setLimitVal( int );
  void setVisualDiff( bool );

signals:
  void addLogEntry( svn::LogEntryPtr );
  void doneLogEntry();
  void showPatch( const QString& name, const QString& file );
  void showCat( const QString& name, const QString& content );

private:
  sc::String       _root;
  sc::String       _name;
  bool             _dir;

  Bookmark*        _bookmark;
  ScModel*         _model;

  // state
  svn::RevisionPtr _revStart;
  svn::RevisionPtr _revStop;
  bool             _copies;
  bool             _changes;
  bool             _limit;
  int              _limitVal;
  bool             _visualDiff;

  svn::LogEntries  _selection;
  svn::Paths       _selectionPaths;
};

typedef boost::shared_ptr<LogViewModel>  LogViewModelPtr;

#endif // _SC_LOGVIEWMODEL_H
