; RUN: llc < %s -verify-machineinstrs -mcpu=pwr9 -mtriple=powerpc64le-unknown-unknown | FileCheck %s
; RUN: llc < %s -verify-machineinstrs -mcpu=pwr8 -mtriple=powerpc64le-unknown-unknown | FileCheck %s

@a = internal global fp128 0xL00000000000000000000000000000000, align 16
@x = internal global [4 x fp128] zeroinitializer, align 16
@y = internal global [4 x fp128] zeroinitializer, align 16

define void @fmul_ctrloop_fp128() {
entry:
  %0 = load fp128, ptr @a, align 16
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %i.06 = phi i64 [ 0, %entry ], [ %inc, %for.body ]
  %arrayidx = getelementptr inbounds [4 x fp128], ptr @x, i64 0, i64 %i.06
  %1 = load fp128, ptr %arrayidx, align 16
  %mul = fmul fp128 %0, %1
  %arrayidx1 = getelementptr inbounds [4 x fp128], ptr @y, i64 0, i64 %i.06
  store fp128 %mul, ptr %arrayidx1, align 16
  %inc = add nuw nsw i64 %i.06, 1
  %exitcond = icmp eq i64 %inc, 4
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void

; CHECK-LABEL: fmul_ctrloop_fp128
; CHECK-NOT: mtctr
}

define void @fpext_ctrloop_fp128(ptr %a) {
entry:
  br label %for.body

for.body:
  %i.06 = phi i64 [ 0, %entry ], [ %inc, %for.body ]
  %arrayidx = getelementptr inbounds double, ptr %a, i64 %i.06
  %0 = load double, ptr %arrayidx, align 8
  %ext = fpext double %0 to fp128
  %arrayidx1 = getelementptr inbounds [4 x fp128], ptr @y, i64 0, i64 %i.06
  store fp128 %ext, ptr %arrayidx1, align 16
  %inc = add nuw nsw i64 %i.06, 1
  %exitcond = icmp eq i64 %inc, 4
  br i1 %exitcond, label %for.end, label %for.body

for.end:
  ret void

; CHECK-LABEL: fpext_ctrloop_fp128
; CHECK-NOT: mtctr
}

define void @fptrunc_ctrloop_fp128(ptr %a) {
entry:
  br label %for.body

for.body:
  %i.06 = phi i64 [ 0, %entry ], [ %inc, %for.body ]
  %arrayidx = getelementptr inbounds [4 x fp128], ptr @x, i64 0, i64 %i.06
  %0 = load fp128, ptr %arrayidx, align 16
  %trunc = fptrunc fp128 %0 to double
  %arrayidx1 = getelementptr inbounds double, ptr %a, i64 %i.06
  store double %trunc, ptr %arrayidx1, align 16
  %inc = add nuw nsw i64 %i.06, 1
  %exitcond = icmp eq i64 %inc, 4
  br i1 %exitcond, label %for.end, label %for.body

for.end:
  ret void

; CHECK-LABEL: fptrunc_ctrloop_fp128
; CHECK-NOT: mtctr
}

declare void @obfuscate(ptr, ...) local_unnamed_addr #2
