package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDbProxyInstanceSsl invokes the rds.GetDbProxyInstanceSsl API synchronously
func (client *Client) GetDbProxyInstanceSsl(request *GetDbProxyInstanceSslRequest) (response *GetDbProxyInstanceSslResponse, err error) {
	response = CreateGetDbProxyInstanceSslResponse()
	err = client.DoAction(request, response)
	return
}

// GetDbProxyInstanceSslWithChan invokes the rds.GetDbProxyInstanceSsl API asynchronously
func (client *Client) GetDbProxyInstanceSslWithChan(request *GetDbProxyInstanceSslRequest) (<-chan *GetDbProxyInstanceSslResponse, <-chan error) {
	responseChan := make(chan *GetDbProxyInstanceSslResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDbProxyInstanceSsl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDbProxyInstanceSslWithCallback invokes the rds.GetDbProxyInstanceSsl API asynchronously
func (client *Client) GetDbProxyInstanceSslWithCallback(request *GetDbProxyInstanceSslRequest, callback func(response *GetDbProxyInstanceSslResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDbProxyInstanceSslResponse
		var err error
		defer close(result)
		response, err = client.GetDbProxyInstanceSsl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDbProxyInstanceSslRequest is the request struct for api GetDbProxyInstanceSsl
type GetDbProxyInstanceSslRequest struct {
	*requests.RpcRequest
	DbInstanceId string `position:"Query" name:"DbInstanceId"`
}

// GetDbProxyInstanceSslResponse is the response struct for api GetDbProxyInstanceSsl
type GetDbProxyInstanceSslResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	DbProxyCertListItems DbProxyCertListItems `json:"DbProxyCertListItems" xml:"DbProxyCertListItems"`
}

// CreateGetDbProxyInstanceSslRequest creates a request to invoke GetDbProxyInstanceSsl API
func CreateGetDbProxyInstanceSslRequest() (request *GetDbProxyInstanceSslRequest) {
	request = &GetDbProxyInstanceSslRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "GetDbProxyInstanceSsl", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDbProxyInstanceSslResponse creates a response to parse from GetDbProxyInstanceSsl response
func CreateGetDbProxyInstanceSslResponse() (response *GetDbProxyInstanceSslResponse) {
	response = &GetDbProxyInstanceSslResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
