## TFSA-2021-188: Heap OOB read in `tf.raw_ops.SparseCountSparseOutput`

### CVE Number
CVE-2021-41210

### Impact
The [shape inference functions for `SparseCountSparseOutput`](https://github.com/tensorflow/tensorflow/blob/e0b6e58c328059829c3eb968136f17aa72b6c876/tensorflow/core/ops/count_ops.cc#L43-L50) can trigger a read outside of bounds of heap allocated array:

```python
import tensorflow as tf

@tf.function
def func():
  return tf.raw_ops.SparseCountSparseOutput(
    indices=[1],
    values=[[1]],
    dense_shape=[10],
    weights=[],
    binary_output= True)

func()
```

The function fails to check that the first input (i.e., `indices`) has rank 2:

```cc
  auto rank = c->Dim(c->input(0), 1);
```

### Patches
We have patched the issue in GitHub commit [701cfaca222a82afbeeb17496bd718baa65a67d2](https://github.com/tensorflow/tensorflow/commit/701cfaca222a82afbeeb17496bd718baa65a67d2).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo 360.
