---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, page, note de bas de page, référence
---

# Comment faire référence à une note de bas de page ?

Il faut pour cela mettre un `\label` *à l'intérieur* de l'argument de `\footnote`. 
Par exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici donc que le texte amène à un premier commentaire\footnote{Guère 
utile} puis, de façon inopinée, à un second\footnote{Encore moins 
utile.\label{manote}}.

Le lecteur éclairé pourra tout particulièrement douter de la 
pertinence de la note \ref{manote}.
\end{document}
```

:::{seealso}
Si vous souhaitez faire référence plusieurs fois à la même note de bas
de page, vous pouvez consulter la question  
"[](/3_composition/texte/renvois/faire_reference_plusieurs_fois_a_une_note_de_bas_de_page)".
:::