---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, communication, diaporama,
              PowerPoint, slides, diapositives, transparents, présentations,
              support de présentation, deux écrans, projecteur, vidéoprojecteur
---

# Comment projeter ma présentation <ctanpkg:beamer> avec deux écrans ?

En combinant des options de <ctanpkg:beamer> et un logiciel de visualisation, 
vous pouvez simuler le comportement de Microsoft Powerpoint 
en mode deux-écrans :
- projeter le contenu de vos diapositives sur grand écran pour votre audience ;
- utiliser l'écran interne de votre ordinateur portable pour garder des notes 
  sous les yeux, et éventuellement une horloge.


## Le mode présentateur de <ctanpkg:beamer>

Utiliser l'extension `pgfpages` (à ne pas confondre avec `pdfpages` !), 
fournie par <ctanpkg:pgf>, avec l'option de <ctanpkg:beamer> 
`show notes on second screen`. Vous pouvez également utiliser 
[handoutWithNotes](ctanpkg:handoutwithnotes), qui s'appuie sur `pgfpages`,
ou l'extension <ctanpkg:pgfmorepages>, conçue comme un remplacement.

```
\documentclass[french]{beamer}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{pgfpages}

  \setbeameroption{show notes on second screen}

\begin{document}
\begin{frame}{Ma première diapositive}
Ici commence mon exposé.
\note{%
  Ne pas oublier de dire bonjour, puis remercier :
  \begin{itemize}
    \item le jury ;
    \item mes parents.
  \end{itemize}\par
}
\end{frame}
\end{document}
```

Le fichier PDF résultant aura des diapos de la largeur de deux écrans, 
et il vous faudra un visualisateur spécial (voir ci-dessous).


## Le logiciel de présentation

Des visualisateurs ont été développés spécialement pour les présentations 
<ctanpkg:beamer>. Ils permettent d'afficher les dapositives 
sur un vidéoprojecteur, et des notes de présentation et une horloge 
sur un second écran :

- [Présentation.app](http://iihm.imag.fr/blanch/software/osx-presentation/) 
  et [SlidePilot](https://slidepilotapp.com/) sous macOS ;
- [PDF presenter console](https://pdfpc.github.io/) sous Linux 
  ([des instructions](https://github.com/pdfpc/pdfpc) sont disponibles 
  pour l'utiliser sous Windows) ;
- [Pympress](https://pypi.org/project/pympress/) sous Linux (instructions 
  disponibles pour macOS et Windows sur la même page).


:::{sources}
- [Is there a nice solution to get a "presenter mode" for Latex presentations?](https://tex.stackexchange.com/q/21777),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::