/*  $Header: /home/cvsroot/dvipdfmx/src/tt_post.h,v 1.1 2004/09/11 14:50:29 hirata Exp $
    
    This is dvipdfmx, an eXtended version of dvipdfm by Mark A. Wicks.

    Copyright (C) 2002 by Jin-Hwan Cho and Shunsaku Hirata,
    the dvipdfmx project team <dvipdfmx@project.ktug.or.kr>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef _TT_POST_H_
#define _TT_POST_H_

#include "sfnt.h"

struct tt_post_table
{
  Fixed    Version;
  Fixed    italicAngle;
  FWord    underlinePosition;
  FWord    underlineThickness;
  ULONG    isFixedPitch;
  ULONG    minMemType42;
  ULONG    maxMemType42;
  ULONG    minMemType1;
  ULONG    maxMemType1; 

  USHORT   numberOfGlyphs;

  char   **glyphNamePtr; /* Glyph names (pointer to C string) */
  char   **names;        /* Non-standard glyph names */

  USHORT   count;        /* Number of glyph names in names[] */
};

extern struct tt_post_table  *tt_read_post_table (sfnt *sfont);
extern void   tt_release_post_table (struct tt_post_table *post);

extern USHORT tt_lookup_post_table  (struct tt_post_table *post, const char *glyphname);

#endif /* _TT_POST_H_ */
