# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright 2014 Canonical Ltd.
# Author: Omer Akram <omer.akram@canonical.com>
#
# This file is part of ubuntu-experience-tests.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>

import testtools

from ubuntuuitoolkit import environment

from ubuntu_experience_tests import fixture_setup


class TestabilityEnvironmentTestCase(testtools.TestCase):

    def get_testability_environment_variable(self):
        try:
            return environment.get_initctl_env_var('QT_LOAD_TESTABILITY')
        except:
            return None

    def test_fixture_must_setup_testability_environment(self):
        """Test the testability environment fixture is setting the variable."""
        fixture = fixture_setup.TestabilityEnvironment()
        self.useFixture(fixture)

        self.assertEquals('1', self.get_testability_environment_variable())

    def test_fixture_must_cleanup_testability_environment(self):
        """Test the testability fixture cleans the variable."""
        original_value = self.get_testability_environment_variable()
        fixture = fixture_setup.TestabilityEnvironment()

        def inner_test():
            class TestWithFakeApplication(testtools.TestCase):
                def test_it(self):
                    self.useFixture(fixture)
            return TestWithFakeApplication('test_it')

        inner_test().run()

        self.assertEqual(
            original_value, self.get_testability_environment_variable())
