;/*******************************************************************************
; * Part of "Intel(R) Active Management Technology (Intel(R) AMT) 
; *                   User Notification Service (UNS)" 
; * 
; * Copyright (c) 2007 Intel Corp.
; * All rights reserved.
; * 
; * Redistribution and use in source and binary forms, with or without
; * modification, are permitted provided that the following conditions
; * are met:
; * 1. Redistributions of source code must retain the above copyright
; *    notice, this list of conditions, and the following disclaimer,
; *    without modification.
; * 2. Redistributions in binary form must reproduce at minimum a disclaimer
; *    substantially similar to the "NO WARRANTY" disclaimer below
; *    ("Disclaimer") and any redistribution must be conditioned upon
; *    including a substantially similar Disclaimer requirement for further
; *    binary redistribution.
; * 3. Neither the names of the above-listed copyright holders nor the names
; *    of any contributors may be used to endorse or promote products derived
; *    from this software without specific prior written permission.
; * 
; * Alternatively, this software may be distributed under the terms of the
; * GNU General Public License ("GPL") version 2 as published by the Free
; * Software Foundation.
; * 
; * NO WARRANTY
; * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
; * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
; * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
; * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
; * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
; * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
; * POSSIBILITY OF SUCH DAMAGES.
; *******************************************************************************/

;//----------------------------------------------------------------------------
;//
;//  File:       UNSMessageFile.mc 
;//
;//  Contents:   User Notification Event Log message DLL.
;//
;//----------------------------------------------------------------------------

;// ---------------------------------------------------------------------------
;// HEADER SECTION
;// ---------------------------------------------------------------------------

MessageIdTypedef=WORD

SeverityNames=(	Success=0x0:STATUS_SEVERITY_SUCCESS
				Informational=0x1:STATUS_SEVERITY_INFORMATIONAL
				Warning=0x2:STATUS_SEVERITY_WARNING
				Error=0x3:STATUS_SEVERITY_ERROR)

LanguageNames=(English=0x409:MSG00001)

;#ifndef EVENT_LOG_MESSAGE_DLL
;#define EVENT_LOG_MESSAGE_DLL


;//**********************Category Definitions***********************
MessageId=1
Facility=Application
Severity=Success
SymbolicName=UNS_WLAN
Language=English
WLAN
.

MessageId=2
Facility=Application
Severity=Success
SymbolicName=UNS_REMOTE_DIAGNOSTIC
Language=English
Remote Diagnostics
.


MessageId=3
Facility=Application
Severity=Success
SymbolicName=UNS_GENERAL
Language=English
UNS
.

MessageId=4
Facility=Application
Severity=Success
SymbolicName=UNS_CIRCUIT_BREAKER
Language=English
System Defense
.

;//********************End of Category Definitions*******************

MessageIdTypedef=DWORD

;//***********************Event Definitions******************************

MessageId=1001
Facility=Application
Severity=Informational
SymbolicName=NETWORK_TRAFFIC_TX_CEASED
Language=English
Security policy invoked. Some or all network traffic (TX) was stopped.
.

MessageId=1002
Facility=Application
Severity=Informational
SymbolicName=NETWORK_CONNECTIVITY_TX_REDUCED
Language=English
Security policy invoked. TX Network connectivity was reduced.
.

MessageId=1003
Facility=Application
Severity=Informational
SymbolicName=NETWORK_TRAFFIC_RX_CEASED
Language=English
Security policy invoked. Some or all network traffic (RX) was stopped.
.

MessageId=1004
Facility=Application
Severity=Informational
SymbolicName=NETWORK_CONNECTIVITY_RX_REDUCED
Language=English
Security policy invoked. RX Network connectivity was reduced.
.

MessageId=1102
Facility=Application
Severity=Informational
SymbolicName=WLAN_PROFILE_INSUFFICIENT
Language=English
WLAN Profile insufficient for management session over WLAN interface. 
.

MessageId=1103
Facility=Application
Severity=Informational
SymbolicName=WLAN_SECURITY_INSUFFICIENT
Language=English
Security parameters insufficient for management session over WLAN interface.
.

MessageId=1104
Facility=Application
Severity=Informational
SymbolicName=WLAN_SESSION_ESTABLISHED
Language=English
Management session was established over WLAN interface.
.

MessageId=1105
Facility=Application
Severity=Informational
SymbolicName=WLAN_SESSION_ENDED
Language=English
Management session over WLAN interface has finished.
.

MessageId=1201
Facility=Application
Severity=Informational
SymbolicName=REMOTE_SOL_STARTED
Language=English
A remote Serial Over LAN session was established.
.

MessageId=1202
Facility=Application
Severity=Informational
SymbolicName=REMOTE_SOL_ENDED
Language=English
Remote Serial Over LAN session finished. User control was restored.
.

MessageId=1203
Facility=Application
Severity=Informational
SymbolicName=REMOTE_IDER_STARTED
Language=English
A remote IDE-Redirection session was established.
.

MessageId=1204
Facility=Application
Severity=Informational
SymbolicName=REMOTE_IDER_ENDED
Language=English
Remote IDE-Redirection session finished. User control was restored.
.

MessageId=2000
Facility=Application
Severity=Informational
SymbolicName=TEXT_MESSAGE
Language=English
%1
.

MessageId=2001
Facility=Application
Severity=Warning
SymbolicName=UNS_WARNING_MESSAGE
Language=English
%1
.

MessageId=2002
Facility=Application
Severity=Error
SymbolicName=UNS_ERROR_MESSAGE
Language=English
%1
.

;//***********************End of Event Definitions***********************

;#endif
