/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif
#include <config.h>
#include <vdkb2/vdkb_ide_def.h>
#include <vdkb2/vdkb_locale.h>
#include <stdlib.h>
extern char* 
ExtractWord(char* src,char* tgt,char* key1,char* key2);
extern char *
ExtractSection (char *buffer, char *section_begin, char* section_end); 
static char *avoid = "\"\r\n\t ";
static char *avoid1 = "\"\r\n\t";
static char buffer[256];
/*
 */
VDKBDefaults::VDKBDefaults(char* resFile):editor(),unit()
{
  rcFile = resFile ? resFile : DEFAULTS_FILE;
}
/* 
 */
void 
VDKBDefaults::LoadDefaults(char* home)
{
  char* buff,*p,*section;
  struct stat info;
  char* file;
  bool setflag = false;
  // look at user home
  sprintf(buffer,"%s/.vdkb2/%s",home,(char*) rcFile);
  if (stat(buffer,&info) == -1)
    // look at share dir
    sprintf(buffer,"%s/%s",VDKB_DATADIR,(char*) rcFile);
  file = buffer;
  if(stat(file,&info) == -1)
    {
      printf("%s",_(user_messages[user_nodefaults]));
      fflush(stdout);
      exit(1);
    }
  
  FILE* fp = fopen(file,"r");
  if(fp)
    {
      int c;
      buff = p = new char[info.st_size+1];
      while( (c = fgetc(fp)) != EOF)
	{
	  if(c == '"')
	    setflag = setflag ? false : true;
	  if (!strchr (setflag ? avoid1 : avoid, c))
	    *p++ = (char) c;
	}
      /*
       */
      *p = '\0';
      fclose(fp);
    }
  else 
    return;
  // load editor defaults
  if((section = ExtractSection(buff,EDITOR_SECTION,END_SECTION)))
    {
      editor.LoadDefaults(section);
      delete[] section;
    }
  // load unit defaults
  if((section = ExtractSection(buff,UNIT_SECTION,END_SECTION)))
    {
      unit.LoadDefaults(section);
      delete[] section;
    }
  // load project defaults
  if((section = ExtractSection(buff,PROJECT_SECTION,END_SECTION)))
    {
      project.LoadDefaults(section);
      delete[] section;
    }
  // finished
  delete[] buff;
}
/////////////////// Editor defaults class ///////////
void 
VDKBEditorDefaults::LoadDefaults(char* section)
{
  int hsize = 0;
  int vsize = 0;
  char *key = new char[128];
  char* p;
  if((p = ExtractWord(section,key,FONT_KEY,END_KEY)))
      font = key;
  if((p = ExtractWord(section,key,FG_KEY,END_KEY)))
      fg = key;
  if((p = ExtractWord(section,key,BG_KEY,END_KEY)))
      bg = key;
  if((p = ExtractWord(section,key,EDITOR_HSIZE_KEY,END_KEY)))
      hsize = atoi(key);
  else
    hsize = 0;
  if((p = ExtractWord(section,key,EDITOR_VSIZE_KEY,END_KEY)))
    vsize = atoi(key);
  else
    vsize = 0;
  if( (hsize > 0) & (vsize > 0) )
      size = VDKPoint(hsize,vsize);

  // syntax colors & fonts
  if((p = ExtractWord(section,key, EDITOR_KEY_FONT_KEY,END_KEY)))
      key_font = key;
  if((p = ExtractWord(section,key, EDITOR_KEY_COLOR_KEY,END_KEY)))
      key_color = key;

  if((p = ExtractWord(section,key, EDITOR_GTK_FONT_KEY,END_KEY)))
      gtk_font = key;
  if((p = ExtractWord(section,key, EDITOR_GTK_COLOR_KEY,END_KEY)))
      gtk_color = key;

  if((p = ExtractWord(section,key, EDITOR_MACRO_FONT_KEY,END_KEY)))
      macro_font = key;
  if((p = ExtractWord(section,key, EDITOR_MACRO_COLOR_KEY,END_KEY)))
      macro_color = key;

  if((p = ExtractWord(section,key, EDITOR_PREPROCESS_FONT_KEY,END_KEY)))
      preprocess_font = key;
  if((p = ExtractWord(section,key, EDITOR_PREPROCESS_COLOR_KEY,END_KEY)))
      preprocess_color = key;

  if((p = ExtractWord(section,key,EDITOR_CONST_FONT_KEY,END_KEY)))
      const_font = key;
  if((p = ExtractWord(section,key,EDITOR_CONST_COLOR_KEY,END_KEY)))
      const_color = key;

  if((p = ExtractWord(section,key,EDITOR_COMMENT_FONT_KEY,END_KEY)))
      comment_font = key;
  if((p = ExtractWord(section,key,EDITOR_COMMENT_COLOR_KEY,END_KEY)))
      comment_color = key;

  // timed saving
  if((p = ExtractWord(section,key, EDITOR_KEY_TIMEDSAVE,END_KEY)))
      timedsave = key;
  // file backup
  if((p = ExtractWord(section,key, EDITOR_KEY_BACKUP,END_KEY)))
      backup = key;
  // editor tab
  if((p = ExtractWord(section,key, EDITOR_KEY_TAB,END_KEY)))
      tab = key;
  // finished
  delete[] key;
}
 
/////////////////// Unit defaults class ///////////
void 
VDKBUnitDefaults::LoadDefaults(char* section)
{
  char *key = new char[128];
  char* p;
  if((p = ExtractWord(section,key,UNIT_COUNT_KEY,END_KEY)))
    count = atoi(key);
  if((p = ExtractWord(section,key,UNIT_NAME_KEY,END_KEY)))
    def_name = key;
  if((p = ExtractWord(section,key,UNIT_CC_EXT_KEY,END_KEY)))
    cc_ext = key;
  if((p = ExtractWord(section,key,UNIT_H_EXT_KEY,END_KEY)))
    h_ext = key;
  // finished
  delete[] key;
}

/////////////////// Project defaults class ///////////
void 
VDKBProjectDefaults::LoadDefaults(char* section)
{
  char *key = new char[128];
  char* p;
  if((p = ExtractWord(section,key,PROJECT_COUNT_KEY,END_KEY)))
    count = atoi(key);
  if((p = ExtractWord(section,key,PROJECT_NAME_KEY,END_KEY)))
    def_name = key;
  if((p = ExtractWord(section,key,PROJECT_PRJ_EXT_KEY,END_KEY)))
    prj_ext = key;
  if((p = ExtractWord(section,key,PROJECT_HIDE_ON_RUN_KEY,END_KEY)))
    hide_on_run = key;
  if((p = ExtractWord(section,key,PROJECT_AUTOSAVE_KEY,END_KEY)))
    autosave = key;
  if((p = ExtractWord(section,key,PROJECT_STARTUPDIR_KEY,END_KEY)))
    startupdir = key;
  if((p = ExtractWord(section,key,PROJECT_WI_RESIZEABLE_KEY,END_KEY)))
    wi_resizeable = key;
  if((p = ExtractWord(section,key,PROJECT_WI_LAYOUT_KEY,END_KEY)))
    wi_layout = key;
  if((p = ExtractWord(section,key,PROJECT_VDK_REF_PATH_KEY,END_KEY)))
    vdk_ref_path = key;
  if((p = ExtractWord(section,key,PROJECT_VDK_REF_BROWSER_KEY,END_KEY)))
    vdk_ref_browser = key;
  if((p = ExtractWord(section,key,PROJECT_SAVE_SESSION_KEY,END_KEY)))
    save_session = key;
  if((p = ExtractWord(section,key,PROJECT_CODE_INDENT_KEY,END_KEY)))
    code_indent = key;
  if((p = ExtractWord(section,key,PROJECT_RUN_MODAL_KEY,END_KEY)))
    run_modal = key;
  if((p = ExtractWord(section,key,PROJECT_EMACS_KEY,END_KEY)))
    emacs = key;
  if((p = ExtractWord(section,key,PROJECT_CODE_AUTOINDENT_KEY,END_KEY)))
    code_autoindent = key;
  if((p = ExtractWord(section,key,PROJECT_SHOWLN_KEY,END_KEY)))
    showln = key;
  if((p = ExtractWord(section,key,PROJECT_EXTASCII_KEY,END_KEY)))
    extascii = key;
  if((p = ExtractWord(section,key,PROJECT_THEME_KEY,END_KEY)))
    theme = key;
  if((p = ExtractWord(section,key,PROJECT_ENABLE_CLASS_BROWSER_KEY,END_KEY)))
    enable_class_browser = key;
  // finished
  delete[] key;
}




