"""Include background images in the rendering scene
(e.g. generated by matplotlib)"""
import matplotlib.pyplot as plt
from vedo import dataurl, show, Mesh, Picture2D

msh = Mesh(dataurl+"limb_ugrid.vtk").shrink(0.8)

# Create a histogram with matplotlib
fig = plt.figure()
plt.hist(msh.celldata["chem_0"], log=True)
plt.title(r'$\mathrm{Matplotlib\ Histogram\ of\ log(chem_0)}$')

pic1 = Picture2D(fig, scale=0.5, pos="bottom-right").ontop()
pic2 = Picture2D(dataurl+"images/embryo.jpg", pos='top-right')

show(msh, pic1, pic2, __doc__, bg='lightgrey', axes=1)
