/*---------------------------------------------------------------------------*\

    This program plays a wave file to a port.


         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2008 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#include "vpbapi.h"
//#include "threads.h"  // for billware

#include <cstdio>
#include <cstdlib>
#include <cstring>


static int arg_exists(int argc, char *argv[], const char *arg)
{ //{{{
	for(int i = 0; i < argc; ++i)
		if(strcmp(argv[i],arg) == 0) return i;

	return 0;
} //}}}

static void usage(const char *argv0)
{ //{{{
	printf("usage: %s [options] file\n\n", argv0);
	printf("  --card num    Play file to card num.  Default is 0\n");
	printf("  --port num    Play file to port num.  Default is 0\n");
	printf("  --playgain db Set the playback gain to db.\n");
	printf("  --recgain db  Set the record gain to db.\n");
	printf("  --dial digits Dial the given digits while playing.\n");
	printf("  --ring        Wait for the line to ring before playing.\n");
	printf("  --rec outfile Record to outfile while playing.\n");
	printf("                Useful for cut-through testing.\n");
#if 0
	printf("  --loop        Enable tx->rx loopback.  Useful for echo testing,\n");
	printf("                but not supported for all hardware types.\n");
	printf("  --hostecho    Enable the host based echo canceller.\n\n");
#endif
} //}}}

static void *event_thread(void *unused)
{ //{{{
	(void)unused;

	char	  s[VPB_MAX_STR];
        VPB_EVENT e;

	for(;;) {
		if(vpb_get_event_sync(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
		}
	}
	return NULL;
} //}}}

int main(int argc, char *argv[])
{ //{{{
	pthread_t       ev_thread;
	VPB_EVENT	e;

	int cardnum = 0;
	int portnum = 0;
	int arg;

	if(argc < 2) {
		usage(argv[0]);
		exit(EXIT_FAILURE);
	}
	if((arg = arg_exists(argc,argv,"--card")) != 0) cardnum = atoi(argv[arg+1]);
	if((arg = arg_exists(argc,argv,"--port")) != 0) portnum = atoi(argv[arg+1]);

	int  h         = vpb_open(cardnum, portnum);
	int  port_type = vpb_get_port_type(h);

	pthread_create(&ev_thread, NULL, event_thread, NULL);

#if 0
	bool loopback  = false;
	if((arg = arg_exists(argc, argv, "--loop")) != 0) {
		vpb_loopback_on(h);
		loopback = true;
		printf("LoopBack turned on!\n");
	}
	if((arg = arg_exists(argc, argv, "--hostecho")) != 0) {
		vpb_hostecho_on(h);
		printf("HostEcho turned on!\n");
	}
#endif

	// optionally set record gain - used for DTMF cut thru testing
	if((arg = arg_exists(argc, argv, "--recgain")) != 0) {
		vpb_record_set_gain(h, atof(argv[arg+1]));
		printf("record gain set to %f\n", atof(argv[arg+1]));
	}
	// optionally set play gain - used for gain testing
	if((arg = arg_exists(argc, argv, "--playgain")) != 0) {
		vpb_play_set_gain(h, atof(argv[arg+1]));
		printf("play gain set to %f\n", atof(argv[arg+1]));
	}

	// optionally record at the same time - used for DTMF cut thru testing
	if((arg = arg_exists(argc, argv, "--rec")) != 0) {
		vpb_record_file_async(h, argv[arg+1], VPB_LINEAR);
		printf("recording to %s\n", argv[arg+1]);
	}

	if(port_type == VPB_FXO) {
		if((arg = arg_exists(argc,argv,"--ring")) != 0) {
			for(;;) {
				printf("Waiting for ring....\n");
				if(vpb_get_event_ch_sync(h,&e,2000) == VPB_OK) {
					if(e.type == VPB_RING) break;
					printf("Got event [%d]\n",e.type);
				}
			}
		}
		vpb_sethook_sync(h, VPB_OFFHOOK);
	}

	// optionally dial digits during playback
	if((arg = arg_exists(argc, argv, "--dial")) != 0) {
		vpb_dial_async(h, argv[arg+1]);
		printf("dialing %s\n", argv[arg+1]);
	}

	printf("Playing '%s' ...\n", argv[argc-1]);

	vpb_play_file_sync(h, argv[argc-1]);
	vpb_record_terminate(h);

	if(port_type == VPB_FXO)    vpb_sethook_sync(h, VPB_ONHOOK);
	//if(loopback)                vpb_loopback_off(h);

	pthread_cancel(ev_thread);
	pthread_join(ev_thread, NULL);

	vpb_close(h);

	return EXIT_SUCCESS;
} //}}}

