/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.data;

import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.Value;

public class ValueMath
implements Value {
    private Function f;
    private double[] param;
    private Value x;
    private Value y;
    private char op;

    public ValueMath(Value value, Value value2, char c) {
        this.x = value;
        this.y = value2;
        this.op = c;
    }

    public ValueMath(Function function, Value value) {
        if (function.getArity() != 1) {
            throw new IllegalArgumentException("Internal Error:  The function in a ValueMath object must have arity 1.");
        }
        this.f = function;
        this.x = value;
        this.param = new double[1];
    }

    @Override
    public double getVal() {
        if (this.f != null) {
            this.param[0] = this.x.getVal();
            return this.f.getVal(this.param);
        }
        double d = this.x.getVal();
        double d2 = this.y.getVal();
        switch (this.op) {
            case '+': {
                return d + d2;
            }
            case '-': {
                return d - d2;
            }
            case '*': {
                return d * d2;
            }
            case '/': {
                return d / d2;
            }
            case '^': {
                return Math.pow(d, d2);
            }
        }
        throw new IllegalArgumentException("Internal Error:  Unknown math operator.");
    }
}

