#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <locale.h>
#include <signal.h>

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "vnc.h"

/* ------------------------------------------------------------------ */

static void usage(FILE *fp)
{
    fprintf(fp,
	    "This is a simple vnc client\n"
	    "\n"
	    "usage: vnc-client [options] display\n"
	    "options:\n"
	    "   -h   Print this text.\n"
	    "   -d   Enable debug output.\n"
	    "   -p   Show mouse pointer.\n"
	    "   -f   Start in fullscreen mode.\n"
	    "   -c   Close on disconnect.\n"
	    "\n"
	    "-- \n"
	    "(c) 2006 Gerd Hoffmann <kraxel@redhat.com>\n");
}

int
main(int argc, char *argv[])
{
    unsigned long vnc_flags = VNC_FLAG_STANDALONE;
    char hostname[65];
    int displayno, port;
    int debug = 0;
    int c;

    gtk_init(&argc, &argv);
    for (;;) {
        if (-1 == (c = getopt(argc, argv, "hdpfc")))
            break;
        switch (c) {
	case 'd':
	    debug++;
	    break;
	case 'p':
	    vnc_flags |= VNC_FLAG_SHOW_MOUSE;
	    break;
	case 'f':
	    vnc_flags |= VNC_FLAG_FULLSCREEN;
	    break;
	case 'c':
	    vnc_flags |= VNC_FLAG_DISCONNECT_CLOSE;
	    break;
        case 'h':
            usage(stdout);
            exit(0);
        default:
            usage(stderr);
            exit(1);
        }
    }

    if (optind < argc) {
	if (2 == sscanf(argv[optind], "%64[^:]:%d", hostname, &displayno)) {
	    port = displayno + 5900;
	    goto connect;
	}
	if (2 != sscanf(argv[optind], "%64[^:]::%d", hostname, &port)) {
	    goto connect;
	}
    }
    strcpy(hostname, "");

connect:
    if (NULL == vnc_open(strlen(hostname) ? hostname : NULL,
			 port, vnc_flags, debug))
	exit(1);

    gtk_main();
    fprintf(stderr,"bye...\n");
    exit(0);
}
