-- File generated by gensoc 394864f
-- (c) 2012-2018, Martin Strubel <hackfin@section5.ch>
-- 
-- Changes to this file will be lost. Edit the source file.
-- 
-- LICENSE: Evaluation license. Not for commercial usage.
----------------------------------------------------------------------------
-- This VHDL package is generated from
-- ../gen/syn-versa_ecp5/neo430-versa_ecp5.xml
-- Stylesheet: vhdlregs v0.1



library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

-- Header:
package system_map is
	-- HW revision tag. Use in your code to sync with firmware.
	constant HWREV_system_map_MAJOR : natural := 0;
	constant HWREV_system_map_MINOR : natural := 0;
	constant HWREV_system_map_EXT   : string := "";

	subtype  regaddr_t is unsigned(7 downto 0);
	subtype  regaddr16_t is unsigned(15 downto 0);


	subtype  REG_SIZE1B is integer range 7 downto 0;
	subtype  REG_SIZE2B is integer range 15 downto 0;
	subtype  REG_SIZE3B is integer range 23 downto 0;
	subtype  REG_SIZE4B is integer range 31 downto 0;

	-- Register and bitfield constants:

-------------------------------------------------------------------------
-- Address segment 'UART'
--         Offset: 

-- UART Control register
	constant R_UART_UART_CONTROL     : regaddr_t := x"00";
-- (16x) Clock divider
	subtype               BV_UART_CLKDIV is integer range 9 downto 0;
-- Enable receive IRQ
	constant              B_RX_IRQ_ENABLE : natural := 14;
-- '1': Reset UART. Clear to run.
	constant              B_UART_RESET : natural := 15;
-- UART status register
	constant R_UART_UART_STATUS      : regaddr_t := x"02";
-- Set when data ready in RX FIFO
	constant              B_RXREADY : natural := 0;
-- Set when TX FIFO ready for data
	constant              B_TXREADY : natural := 1;
-- '1' when TX in progress
	constant              B_TXBUSY : natural := 2;
-- Sticky framing error. Set when stop bit not null. Reset by UART_RESET.
	constant              B_FRERR : natural := 5;
-- Transmitter FIFO overrun. Cleared by UART_RESET.
	constant              B_TXOVR : natural := 6;
-- Receiver FIFO overrun. Cleared by UART_RESET.
	constant              B_RXOVR : natural := 7;
-- RX bit counter
	subtype               BV_BITCOUNT is integer range 10 downto 8;
-- UART receiver register
	constant R_UART_UART_RXR         : regaddr_t := x"04";
-- UART receive data
	subtype               BV_RXDATA is integer range 7 downto 0;
-- 1 when data valid (mirror of RXREADY bit)
	constant              B_DVALID : natural := 8;
-- UART transmitter register
	constant R_UART_UART_TXR         : regaddr_t := x"04";


	type uart_ReadPort is record
		--! Exported value for register 'R_UART_UART_STATUS'
		--! Exported value for bit (vector) 'RXREADY'
		rxready : std_logic;
		--! Exported value for bit (vector) 'TXREADY'
		txready : std_logic;
		--! Exported value for bit (vector) 'TXBUSY'
		txbusy : std_logic;
		--! Exported value for bit (vector) 'FRERR'
		frerr : std_logic;
		--! Exported value for bit (vector) 'TXOVR'
		txovr : std_logic;
		--! Exported value for bit (vector) 'RXOVR'
		rxovr : std_logic;
		--! Exported value for bit (vector) 'BITCOUNT'
		bitcount : unsigned(BV_BITCOUNT);
		--! Exported value for register 'R_UART_UART_RXR'
		--! Exported value for bit (vector) 'RXDATA'
		rxdata : unsigned(BV_RXDATA);
		--! Exported value for bit (vector) 'DVALID'
		dvalid : std_logic;
	end record;

	type uart_WritePort is record
		--! Exported value for register 'R_UART_UART_CONTROL'
		--! Exported value for bit (vector) 'UART_CLKDIV'
		uart_clkdiv : unsigned(BV_UART_CLKDIV);
		--! Exported value for bit (vector) 'RX_IRQ_ENABLE'
		rx_irq_enable : std_logic;
		--! Exported value for bit (vector) 'UART_RESET'
		uart_reset : std_logic;
		--! Exported value for register 'R_UART_UART_TXR'
		uart_txr : unsigned(REG_SIZE1B);
		--! Notify access of Register 'UART_RXR'
		select_uart_rxr : std_logic;
		--! Notify access of Register 'UART_TXR'
		select_uart_txr : std_logic;
	end record;



end system_map;

