/****************************************************************************
**  Copyright (c) 2013, Adel Kara Slimane, the ZeGrapher project <contact@zegrapher.com>
**
**  This file is part of the ZeGrapher project, version 2.0.
**
**  ZeGrapher is free software: you may copy, redistribute and/or modify it
**  under the terms of the GNU General Public License as published by the
**  Free Software Foundation, either version 3 of the License, or (at your
**  option) any later version.
**
**  This file is distributed in the hope that it will be useful, but
**  WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/


#include <QtGui/QApplication>
#include "zegrapher.h"
#include <QLocale>
#include <QTranslator>
#include <QTextCodec>
#include <QLibraryInfo>

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
    QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8"));  

    QLocale locale;
    QString localeString = locale.system().name().section("_",0,0);
    QTranslator translator;
    translator.load(QString("qt_") + localeString, QLibraryInfo::location(QLibraryInfo::TranslationsPath));

    if(locale.language() != QLocale::French)
       translator.load(":/ZeGrapher_en.qm");


    a.installTranslator(&translator);

    MainWindow w;
    w.show();

    return a.exec();
}
